(
	-- The 3ds max "Physical Material""

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"cbd3dcad-6eff-4094-9e9a-53f0414aebac"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			-- Bump map
			if mtl.bump_map_on AND mtl.bump_map != undefined do 
				append res #("bump", mtl.bump_map, "normalPerturb", 1)		

			-- Base reflectance			
			if mtl.base_weight_map_on AND mtl.base_weight_map != undefined do 
				append res #("base_weight", mtl.base_weight_map, "resultFloat")
			if mtl.base_color_map_on AND mtl.base_color_map != undefined do 
				append res #("base_color", mtl.base_color_map)
			if mtl.reflectivity_map_on AND mtl.reflectivity_map != undefined do 
				append res #("refl_weight", mtl.reflectivity_map, "resultFloat")
			
			if mtl.roughness_map_on AND mtl.roughness_map != undefined do (
				append res #("refl_rough", mtl.roughness_map, "resultFloat")			

				-- If they are locked, also assign to transparency roughness
				if (mtl.trans_roughness_lock) do
					append res #("tran_rough", mtl.roughness_map, "resultFloat")			
			)

			if mtl.metalness_map_on AND mtl.metalness_map != undefined do 
				append res #("metalness", mtl.metalness_map, "resultFloat")			

			if mtl.diff_rough_map_on AND mtl.diff_rough_map != undefined do 
				append res #("diff_rough", mtl.diff_rough_map, "resultFloat")			

			if mtl.refl_color_map_on AND mtl.refl_color_map != undefined do 
				append res #("refl_color", mtl.refl_color_map)			
			
			-- Transmittance
			if mtl.transparency_map_on AND mtl.transparency_map != undefined do 
				append res #("trans_weight", mtl.transparency_map, "resultFloat")			
			if mtl.trans_color_map_on AND mtl.trans_color_map != undefined do 
				append res #("trans_color", mtl.trans_color_map)

			if mtl.trans_roughness_lock == false AND mtl.trans_rough_map_on AND mtl.trans_rough_map != undefined do 
				append res #("tran_rough", mtl.trans_rough_map)

			-- SSS
			if mtl.scattering_map_on AND mtl.scattering_map != undefined do 
				append res #("scatter_weight", mtl.scattering_map, "resultFloat")			
			if mtl.sss_color_map_on AND mtl.sss_color_map != undefined do 
				append res #("scatter_color", mtl.sss_color_map)
			if mtl.sss_scale_map_on AND mtl.sss_scale_map != undefined do 
				append res #("scatter_depth", mtl.sss_scale_map, "resultFloat")			

			-- Emission
			if mtl.emission_map_on AND mtl.emission_map != undefined do 
				append res #("emission_weight", mtl.emission_map, "resultFloat")			
			if mtl.emit_color_map_on AND mtl.emit_color_map != undefined do 
				append res #("emission_filter", mtl.emit_color_map)

			-- Coating
			if mtl.coat_map != undefined and mtl.coat_map_on do 
				append res #("coat_weight",  mtl.coat_map, "resultFloat")
			if mtl.coat_color_map_on AND mtl.coat_color_map != undefined do 
				append res #("coat_color", mtl.coat_color_map)
			if mtl.coat_rough_map_on AND mtl.coat_rough_map != undefined do 
				append res #("coat_rough", mtl.coat_rough_map, "resultFloat")			
			if mtl.coat_bump_map_on AND mtl.coat_bump_map != undefined do 
				append res #("coat_bump", mtl.coat_bump_map, "normalPerturb", 1)		


			-- Anisotropy			
			if mtl.anisotropy_map != undefined and mtl.anisotropy_map_on do 
				append res #("anisotropy",  mtl.anisotropy_map, "resultFloat")
			if mtl.aniso_angle_map != undefined and mtl.aniso_angle_map_on do 
				append res #("angle",       mtl.aniso_angle_map, "resultFloat")

			if mtl.aniso_mode == 1 do 
			(
				append res #("utangent", undefined, "u_tangent_" + (mtl.aniso_channel as String))
				append res #("vtangent", undefined, "v_tangent_" + (mtl.aniso_channel as String))
			)


			if mtl.cutout_map_on AND mtl.cutout_map != undefined do 
				append res #("cutout", mtl.cutout_map, "resultFloat")		

            -- MAXX-32321: 2017-08-17: IOR map didn't work
			if mtl.trans_ior_map_on AND mtl.trans_ior_map != undefined do 
				append res #("refl_ior", mtl.trans_ior_map, "resultFloat")

			-- print res
		
			res
		),

		fn GetParams mtl context =
		(
			local res = #()	
			
			append res #("bump_amount",  mtl.bump_map_amount)		

			append res #("base_weight",         mtl.base_weight)
			append res #("base_color",          mtl.base_color)
			append res #("refl_weight",         mtl.reflectivity)
			append res #("refl_color",          mtl.refl_color)
			append res #("refl_ior",            mtl.trans_ior)

			append res #("anisotropy",          mtl.anisotropy)
			append res #("angle",               mtl.anisoangle)
			
			append res #("refl_rough",          mtl.roughness)
			append res #("refl_rough_invert",   mtl.roughness_inv)
			append res #("metalness",           mtl.metalness)
			append res #("diff_rough",          mtl.diff_roughness)

			append res #("trans_weight",        mtl.transparency)
			append res #("trans_color",         mtl.trans_color)
			append res #("trans_color2",        mtl.trans_color)

			if mtl.trans_roughness_lock then (
				append res #("trans_rough",        mtl.roughness)
				append res #("trans_rough_inv",    mtl.roughness_inv)
			)
			else
			(
				append res #("trans_rough",        mtl.trans_roughness)
				append res #("trans_rough_inv",    mtl.trans_roughness_inv)
			)

			append res #("scatter_weight",      mtl.scattering)
			append res #("scatter_color",       mtl.sss_color)
			append res #("scatter_depth",       mtl.sss_scale)
			append res #("scatter_ratio",       (mtl.sss_scatter_color * mtl.sss_depth))

			append res #("coat_weight",         mtl.coating)
			append res #("coat_color",          mtl.coat_color)
			append res #("coat_rough",          mtl.coat_roughness)
			append res #("coat_rough_inv",      mtl.coat_roughness_inv)
			append res #("coat_ior",            mtl.coat_ior)
			append res #("coat_affect_color",   mtl.coat_affect_color)
			append res #("coat_affect_rough",   mtl.coat_affect_roughness)
			append res #("coat_bump_amount",    mtl.clearcoat_bump_map_amt)


			append res #("brdf_mode",           mtl.brdf_mode)
			append res #("brdf_high",           mtl.brdf_high)
			append res #("brdf_low",            mtl.brdf_low)
			append res #("brdf_curve",          mtl.brdf_curve)

			append res #("thin_walled",         mtl.thin_walled)

			append res #("cutout", 1.0) -- default to Opaque
			

		    local emit = false
			
				
			if mtl.emission_map != undefined and mtl.emission_map_on do emit = true
			if mtl.emit_color_map != undefined and mtl.emit_color_map_on do emit = true

			append res #("emission_weight", mtl.emission)
			append res #("emission_filter", mtl.emit_color)

			if mtl.emission > 0.0 do emit = true

			if mtl.trans_depth > 0.0 and mtl.thin_walled == false then
			(
				append res #("trans_depth_inverse", 1.0 / mtl.trans_depth)
			)
			else
			(
				append res #("trans_depth_inverse", 0.0)
			)

			-- Effective luminance is computed by the plugin
			append res #("emission",     mtl.EffectiveLuminance)

			-- Commenting this out to fixx MAXX-48099, but leaving it here
			-- hoping it can be revisited in the future. The problem: The new ART makes objects
			-- non-shadow-casting if the emissive flag is set
			-- append res #("att:emissive", emit)
			
			-- print res
			
			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQC0tyWfXrZTm7ebX47ZCmd4yPVppUe8LWI0
-- TBYh8kdzrin3s6jAdaOBYvGNFuuKD6ZrTzKgcN6KzZvT+s5TJJ3BsjMifycev0Vc
-- pxq+BICKs4B112x/D0suu4UtLwX+gDb2FLPXW4aFH6b+/pVNBE09H+6Qdbo2AJ3w
-- 1UUT75Nj+XnGr302UI3QJ8rZwlWK9Fd/eXFHUmRrKRs7XaSeFsJPWX27c4ALtNW7
-- U8CuIk+KcmwczPsN0Wiexfisa+Jkn+cMhV0COlJHIEj5hr4ld8/r/Mkwbo5eyjlX
-- GxqhHs8zzFLpq9YEuJ+eqma2FFJ7GGD8LALPvmxxEgDHFULrSvPo
-- -----END-SIGNATURE-----